/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextFieldLimit
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private int limit;
    private boolean toUppercase = false;
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMERIC = "0123456789";
    public static final String FLOAT = "0123456789.";
    public static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String HEXADECMAL = "0123456789ABCDEFabcdef";
    public static final String SYMBOLIC = "*";
    public static final String ALPHA_NUMERIC_SYMBOLIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789*";
    protected String acceptedChars = null;
    protected boolean negativeAccepted = false;

    JTextFieldLimit(int n) {
        this.limit = n;
    }

    JTextFieldLimit(int n, boolean bl) {
        this.limit = n;
        this.toUppercase = bl;
        this.acceptedChars = ALPHA_NUMERIC;
    }

    JTextFieldLimit(String string, int n) {
        this.acceptedChars = string;
        this.limit = n;
    }

    public void setNegativeAccepted(boolean bl) {
        if (this.acceptedChars.equals(NUMERIC) || this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals(ALPHA_NUMERIC)) {
            this.negativeAccepted = bl;
            this.acceptedChars = this.acceptedChars + "-";
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (this.getLength() + string.length() <= this.limit) {
            if (this.toUppercase) {
                string = string.toUpperCase();
            }
            if (this.acceptedChars != null) {
                if (this.acceptedChars.equals(UPPERCASE)) {
                    string = string.toUpperCase();
                } else if (this.acceptedChars.equals(LOWERCASE)) {
                    string = string.toLowerCase();
                }
                for (int i = 0; i < string.length(); ++i) {
                    if (this.acceptedChars.indexOf(String.valueOf(string.charAt(i))) != -1) continue;
                    return;
                }
                if ((this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals("0123456789.-") && this.negativeAccepted) && string.indexOf(".") != -1 && this.getText(0, this.getLength()).indexOf(".") != -1) {
                    return;
                }
                if (this.negativeAccepted && string.indexOf("-") != -1 && (string.indexOf("-") != 0 || n != 0)) {
                    return;
                }
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

